/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.Data;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;     
/**
 *
 * @author mu125243
 */
public class DataTraverser {
    
    private Data dataObj;
    
    /**
     *  Key of the map is one of the DataTypes. Assumption is there is one 
     * to one relationship between key and its value. 
     */
    private Map typeToData;
    
    /** Creates a new instance of DataTraverser */
    public DataTraverser(Data dataObj) {
        this.dataObj = dataObj;
    }
    
    /**
     * Returns the data object which this traverser is visiting
     * @return Data
     */
    public Data getSource() {
        return dataObj;
    }
    /**
     * Return child data object of type supplied as a parameter
     * @param type data object type
     * @return data object 
     */
    public Iterator<Data> getData(String type) {
        if(typeToData == null)
            traverse();
        
        Object obj = typeToData.get(type);
        if(obj != null) {
            ArrayList list = (ArrayList)obj;
            return list.iterator();
        }
        return new ArrayList().iterator();
    }
    
    private void traverse() {
        if(typeToData == null)
            typeToData = new HashMap(5);
        Iterator<Data> children = dataObj.getChildren();
        while(children.hasNext()) {
            Data child = children.next();
            ArrayList list = (ArrayList)typeToData.get(child.getType());
            if (list == null) {
                list = new ArrayList(5);
                typeToData.put(child.getType(), list);
            }
            list.add(child);
        }
    }
}
