/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.util.List;



/**
 * A container holds other nodes.  For example, an HTML element is a container
 * which can hold attributes, comments, processing instructions, text nodes,
 * and other elements.
 */
public interface Container extends HTMLComponent {
    
    
    /**
     * Add the node to the end of this container.
     * @param node The node to add.
     */
    public void add(HTMLComponent node);
    
    
    /**
     * Get all children of this element.
     * @return	The list of all children.
     * @see HTMLComponent
     */
    public List<HTMLComponent> children();
    
    
    /**
     * Filter out children of a specific type.
     * @param type	The class object for the objects to filter.
     * @return	The list of all objects matching the type.
     */
    public <T extends HTMLComponent> List<T> get(Class<T> type);
    

    /**
     * Remove the specified node from this container.  If the node is
     * not present, nothing is done.
     * @param node	The node to remove.
     * @return	This container.
     */
    public void delete(HTMLComponent node);
}
