/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentEvent.java
 *
 * Created on April 8, 2003.
 */

package com.sun.enterprise.deployment.backend;

import java.util.EventObject;

/**
 * A <code>DeploymentEvent</code> event gets delivered whenever a 
 * <code>DeploymentEventListener</code> registers itself with the 
 * <code>DeploymentEventManager</code>.
 *
 * @author Marina Vatkina
 */
public class DeploymentEvent
    extends EventObject
{

    public static final int UNKNOWN       = 0;

    public static final int PRE_DEPLOY    = 1;

    public static final int POST_DEPLOY   = 2;

    public static final int PRE_UNDEPLOY  = 3;

    public static final int POST_UNDEPLOY = 4;


    /** Event type */
    private int eventType = 0;

    /** 
     * Constructs <code>DeploymentEvent</code> from an event type
     * and a <code>DeploymentEventInfo</code> instance.
     * @param eventType as one of the valid Event types.
     * @param info the DeploymentEventInfo instance to be used for this event.
     */
    public DeploymentEvent(int eventType, DeploymentEventInfo info) {
        super(info);
        this.eventType = eventType;
    }

    /** 
     * Returns event type of this event.
     * @return event type of this event.
     */
    public int getEventType() {
        return eventType;
    }

    /** 
     * Returns event info of this event.
     * @return event info of this event.
     */
    public DeploymentEventInfo getEventInfo() {
        return (DeploymentEventInfo)getSource();
    }

}
