
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.util.*;
import com.sun.logging.LogDomains;
import java.util.logging.*;
import java.util.*;
import java.lang.*;
import java.lang.reflect.*;
import java.io.IOException;
import org.xml.sax.SAXParseException;

/**
 *  This is Resource Adapter configuration parser. It parses the
 *  ra.xml file for the Resources adapter javabean properties 
 *
 *  @author      Srikanth P
 *
 */

public class ResourceAdapterConfigParserImpl implements ConnectorConfigParser {

    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    
    /**
     *  Default constructor.
     *
     */

    public ResourceAdapterConfigParserImpl() {

    }

    /** Parses the ra.xml for the Resource Adapter javabean properties.
     *  Here the second parameter connectionDefName is not used and can
     *  be null or any value.
     *
     *  It throws ConnectorRuntimeException if module dir is null or
     *  corresponing rar is not deployed i.e invalid moduleDir parameter.
     *
     *  @param desc ConnectorDescriptor pertaining to rar.
     *  @param  Not used. Can be null or any value,
     *  @return Javabean properties with the propety names and values
     *          of propeties. The property values will be the values
     *          mentioned in ra.xml if present. Otherwise it will be the
     *          default values obtained by introspecting the javabean.
     *          In both the case if no value is present, empty String is
     *          returned as the value.
     *  @throws  ConnectorRuntimeException if moduleDir is null .
     *           If corresponding rar is not deployed i.e moduleDir is invalid.
     */

    public Properties getJavaBeanProps(ConnectorDescriptor desc,
              String connectionDefName, String rarName) throws ConnectorRuntimeException
    {

        if(desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }

        /* ddVals           -> Properties present in ra.xml
        *  introspectedVals -> All properties with values
        *                                 obtained by introspection of resource
        *                                  adapter javabean
        *  mergedVals       -> merged props of raConfigPros and
        *                                 allraConfigPropsWithDefVals
        */

        Set ddVals = desc.getConfigProperties();
        Properties mergedVals = null;
        String className = desc.getResourceAdapterClass();
        Properties introspectedVals = null;
        if(className != null && className.length() != 0) {
            introspectedVals=configParserUtil.introspectJavaBean(
                                       className,ddVals);
            mergedVals = configParserUtil.mergeProps(ddVals,introspectedVals);
        }
        return mergedVals;
    }

}
