/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.repository.*;
import javax.resource.spi.ManagedConnectionFactory;


/**
 * Interface class for different types (1.0 and 1.5 complient) resource 
 * adapter abstraction classes. 
 * Containes methods for setup(initialization), destroy and creation of MCF.
 *
 * @author Srikanth P and Binod PG
 */


public interface ActiveResourceAdapter {

    /**
     * It initializes the resource adapter. 
     * @throws ConnectorRuntimeException. This exception is thrown if the
     *         setup/initialization fails. 
     */

    public void setup() throws ConnectorRuntimeException;

    /**
     * uninitializes the resource adapter. 
     */

    public void destroy();

    /** Returns the Connector descriptor which represents/holds ra.xml
     *  @return ConnectorDescriptor Representation of ra.xml.
     */

    public ConnectorDescriptor getDescriptor();

    /** Creates managed Connection factory instance.
     *  @param ccp Connector connection pool which contains the pool properties
     *             and ra.xml values pertaining to managed connection factory
     *             class. These values are used in MCF creation.
     *  @param jcl Classloader used to managed connection factory class.
     *  @return ManagedConnectionFactory created managed connection factory
     *          instance
     */

    public ManagedConnectionFactory createManagedConnectionFactory
                      (ConnectorConnectionPool cpr, ClassLoader loader);

    /**
     * Returns the class loader that is used to load the RAR.
     * @return <code>ClassLoader</code> object.
     */
    public ClassLoader getClassLoader();
    
    /**
     * Returns the module Name of the RAR
     * @return A <code>String</code> representing the name of the 
     * connector module
     */
    public String getModuleName();
}
