/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 *The request wrapper object by which static document requests are delegated
 *to the default servlet implementation.
 *
 * @author tjquinn
 */
public class JWSSystemServletRequestWrapper extends HttpServletRequestWrapper {
  
    /** URI of the content requested, relative to the app server's installation directory */
    private URI relativeFileURI;
    
    /** Creates a new instance of JWSSystemServletRequestWrapper */
    public JWSSystemServletRequestWrapper(HttpServletRequest request, URI relativeFileURI) {
        super(request);
        this.relativeFileURI = relativeFileURI;
    }
    
    /**
     *Overrides the default implementation to provide the web container with
     *the correct path, relative to the actual doc base which is the installation
     *directory of the app server.
     *@return String containing the path information for the document
     */
    public String getPathInfo() {
        return "/" + relativeFileURI.toString();
    }
}
