/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.appclient;

import javax.naming.InitialContext;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.InjectionManager;
import com.sun.enterprise.util.InjectionManagerImpl;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.iiop.PEORBConfigurator;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import java.util.Properties;
/**
 * This is the application client container. It performs tasks such as
 * user login and other initialization based on the deployment descriptor
 * information.
 * @author Vivek Nagar
 * @author Harpreet Singh
 */
public class AppContainer
{
    public static final int USERNAME_PASSWORD = 1;
    public static final int CERTIFICATE = 2;
    // harry - added for LoginContextDriver access
    public static final int ALL = 3;
    private static final boolean debug = false;

    private ApplicationClientDescriptor descriptor = null;
    private Switch sw = null;
    private NamingManager nm = null;

    // the handler should be defined - it will be used by the J2EEKeyManager
    // to pick up the certificate alias when performing SSL handshake during
    // lazy authentication.
    private static CallbackHandler handler = null;
    private boolean guiAuth = true;

    private static Logger _logger = LogDomains.getLogger(LogDomains.ACC_LOGGER);

    /**
     * The constructor takes the application client descriptor as an argument.
     */
    public AppContainer(ApplicationClientDescriptor desc, boolean useGuiAuth) 
    {
	sw = Switch.getSwitch();
	sw.setContainerType(Switch.APPCLIENT_CONTAINER);
        // Inform the JTS that this is a APPCLIENT_CONTAINER . This is required
        // as JTS can not use Switch interface as it creates a circular dependency
        // Configuration.setAsAppClientConatiner();
	descriptor = desc;
        guiAuth = useGuiAuth;
    }

    /**
     * This returns the CallbackHandler for the AppContainer.
     * @return handler
     */
    public static CallbackHandler getCallbackHandler() {
        return handler;
    }

    /**
     * This is called by main before the actual main of the application
     * is invoked. It initializes the container and performs login for
     * the user.
     * @return the main class of the application.
     */
    public String preInvoke(Properties props) throws Exception
    {
     	InitialContext ic = new InitialContext(props);

	ComponentInvocation ci = new ComponentInvocation(null, this);

	InvocationManager im = new InvocationManagerImpl();
	sw.setInvocationManager(im);

	// Initialize Transaction service. By now the ORB must have
	// been created during the new InitialContext() call using
	// the ORBManager
	PEORBConfigurator.initTransactionService(null, new Properties() );
	
	/* Create the transaction manager and set it in the switch. */
	J2EETransactionManager tm = new J2EETransactionManagerImpl();
	sw.setTransactionManager(tm);

	im.preInvoke(ci);
 	
	// Do security setup
	String callbackHandler = descriptor.getCallbackHandler();
        
	_logger.fine("Callback Handler:" + callbackHandler);
        
	initializeCallbackHandler(callbackHandler);
	
	/* Login the user. */
	// eager authentication!
	boolean doLogin = 
	    Boolean.valueOf(System.getProperty("startup.login", "false")).booleanValue();
	if(doLogin) {
            _logger.info("acc.init_login");
	    String loginMech = System.getProperty(
		"com.sun.enterprise.loginMech", "password");
	    if(loginMech.equalsIgnoreCase("ssl")) {
		LoginContextDriver.doClientLogin(CERTIFICATE, handler);
	    } else if(loginMech.equalsIgnoreCase("all")) {
		LoginContextDriver.doClientLogin(ALL, handler);
	    } else {
		LoginContextDriver.doClientLogin(USERNAME_PASSWORD, handler);
	    }
	}

	/* Create the naming manager and set it in the switch. */
	nm = new NamingManagerImpl(ic);
	sw.setNamingManager(nm);

	String mainClass = descriptor.getMainClassName();
	sw.setDescriptorFor(this, descriptor);
	nm.bindObjects(descriptor);

        // Create the Injection Manager and set it on the switch.
        InjectionManager injectionMgr = new InjectionManagerImpl();
        sw.setInjectionManager(injectionMgr);               

	return mainClass;
    }

    /**
     * This is called by the main after the real main of the application
     * is invoked. Performs cleanup.
     */
    public void postInvoke() throws Exception
    {
	nm.unbindObjects(descriptor);
    }


    /**
     * Initialize the JAAS login modules.
     * One login module per realm (default and certificate).
     * @param the JAAS callback handler class.
     * @exception LoginException if there was an error.
     */
    private void initializeCallbackHandler(String callbackHandler){
	Class handlerClass = null;
	handler = null;
	
	try {
	    if(callbackHandler != null) {
	        handlerClass = Class.forName(callbackHandler);
		handler = (CallbackHandler) handlerClass.newInstance();
	    } else {
	        handler = new com.sun.enterprise.security.auth.login.LoginCallbackHandler(guiAuth);
	    }
	} catch(Exception e) {
            _logger.log(Level.FINE, "Could not instantiate specified " +
                         "callback handler:" + e.getMessage(), e);
            _logger.info("acc.using_default_callback");
	    handler = new com.sun.enterprise.security.auth.login.LoginCallbackHandler(guiAuth);
	} 
    }
}

