/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.util;

// JDK classes
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

// our classes
import com.sun.enterprise.admin.util.Assert;


/**
	Exists to convert a Throwable to a String.  This gives more control
	than having a printStackTrace() go directly to a PrintStream
	or PrintWriter.  It also defers the conversion to a String until a later
	time when the caller finds it convenient.
 */
public final class ThrowableToString
{
	private final static int	kDefaultBufferSize	= 512;
	
	private final Throwable	mThrowable;
	
	/**
		Constructor--takes any non-null Throwable
		
		@param throwable	any Throwable
	 */
		public 
	ThrowableToString( Throwable  throwable )
	{
		Assert.assertit( throwable != null, "null throwable" );
		mThrowable	= throwable;
	}
	
	/**
		Convert the Throwable to a String.
	 */
		public String
	toString()
	{
    	final ByteArrayOutputStream	output	=
    								new ByteArrayOutputStream( kDefaultBufferSize );
    	final PrintStream		print	= new PrintStream( output );
    	
        mThrowable.printStackTrace( print );
        
        return( output.toString() );
	}
}



