/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: TargetType.java,v 1.3 2005/12/25 04:14:39 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

public final class TargetType
{
    /**
     * A named configuration
     */
    public static final TargetType CONFIG = new TargetType(1, "configuration");
    /**
     * A named server of any type: not including the domain admin server, a clustered
     * server instance, an unclustered server instance
     */
    public static final TargetType SERVER = new TargetType(2, "server instance");
    /**
     * The domain
     */
    public static final TargetType DOMAIN = new TargetType(3, "domain");
    /**
     * A named cluster
     */
    public static final TargetType CLUSTER = new TargetType(4, "cluster");
    /**
     * A named node agent
     */
    public static final TargetType NODE_AGENT = new TargetType(5, "node agent");             
    
    /**
     * A stand alone server instance
     */
    public static final TargetType STANDALONE_SERVER = new TargetType(6, "standalone server instance");   
    
    /**
     * An unclustered server instance
     */
    public static final TargetType UNCLUSTERED_SERVER = new TargetType(7, "unclustered server instance");   
    
    /**
     * A stand alone cluster
     */
    public static final TargetType STANDALONE_CLUSTER = new TargetType(8, "standalone cluster");  
    
    /**
     * The domain administration server
     */
    public static final TargetType DAS = new TargetType(9, "domain administration server");  

    private int _type;
    //Note: it does not seem as if the name needs to be localizable, hence we are
    //not using the string manager here.
    private String _name;
    
    private TargetType(int type, String name)
    {
        _type = type;
        _name = name;
    }
    
    public String getName() {
        return _name;
    }    
    
    int getType() {
        return _type;
    }    
    
    public boolean equals(Object obj)
    {
        if (obj instanceof TargetType) {
            return ((TargetType)obj).getType() == this.getType() ? true : false;
        }
        return false;
    }
}
