/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: DASTarget.java,v 1.3 2005/12/25 04:14:38 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

//jdk imports
import java.io.Serializable;

//jmx imports
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;

//config imports
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.util.i18n.StringManager;

import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.NodeAgent;

public class DASTarget extends ServerTarget
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(DASTarget.class);
    
    protected DASTarget(String name, ConfigContext cc)
    {
        super(name, cc);
    }

    public TargetType getType()
    {
        return TargetType.DAS;
    }

    /**
     * Return all the cluster associated with this server
     */    
    public Cluster[] getClusters() throws ConfigException
    {
       throw new ConfigException(strMgr.getString("target.not_supported",
            "getClusters", getType().getName()));
    }
    
    /**
     * Return the node agent associated with this server.
     */    
    public NodeAgent[] getNodeAgents() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getNodeAgents", getType().getName()));
    }        
}
