/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.snmp;

//import from DomainRegistry
import com.sun.enterprise.admin.common.domains.registry.DomainRegistry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryException;
import com.sun.enterprise.admin.common.domains.registry.DomainEntry;

// jdk imports
import java.lang.*;
import java.io.*;
import java.util.Vector;
import java.util.Arrays;
import java.util.Iterator;

public class ExtractDomainRoots {
	
	public String[] getAllDomainRoots() {
		Vector vt = new Vector();
        String[] domains = null;
        try
        {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            Iterator it = domainRegistry.iterator();
            while (it.hasNext())
            {
                DomainEntry entry = (DomainEntry)it.next();
                vt.addElement(entry.getRoot().getPath());
            }
			domains = new String[vt.size()];
			domains = (String[])vt.toArray(domains);
        }
        catch (DomainRegistryException e)
        {
			System.err.println("ExtractDomainRoots: Exception caught, while parsing the domain registry");
			e.printStackTrace();
        }
       	return domains;
	}

	public void writeDomainInfo(String[] domains) {
		String fileName = new String("/tmp/appserv_domainInfo.txt"); 
		try {
			File domainFile = new File(fileName);
			FileWriter domainFileWriter = new FileWriter(domainFile);
			for(int i = 0; i< domains.length; i++)
			{
				domainFileWriter.write(domains[i]);
				domainFileWriter.write("\n");
				System.out.println(domains[i]);
			}
			domainFileWriter.flush();
			domainFileWriter.close();
		}
		catch(IOException e) {
			System.out.println("ExtractDomainRoots: IOException caught while writing domain information to file");
			e.printStackTrace();
		}
		catch(Exception e) {
			System.out.println("ExtractDomainRoots: Exception caught while writing domain information to file");
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		ExtractDomainRoots droot = new ExtractDomainRoots();
		String[] dInfo = droot.getAllDomainRoots();
		droot.writeDomainInfo(dInfo);
	}
}
