/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.exception.J2EEWebModuleException;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.J2eeApplication;


//Admin Imports
import com.sun.enterprise.admin.common.exception.MBeanConfigException;

/**
    Represents a managed Web Module. This is a part of a deployed application.
    When a J2EE application is deployed, instances of this MBean are registered
    in the MBeanServer.
    <p>
    There will be as many instances of this MBean as there are Web Modules (per
    application).
    <p>
    ObjectName of this MBean is:
        ias:type=J2EEWebModule, AppName= <appName>, ModuleName=<moduleName>
*/
public class ManagedJ2EEWebModule extends ConfigMBeanBase
{
    private static final String[][] MAPLIST    = null;
    private static final String[]   ATTRIBUTES  = null;
    private static final String[]   OPERATIONS  = 
    {
        "getServlets(),   INFO",
    };

    
    /**
        Default constructor sets MBean description tables
    */
    public ManagedJ2EEWebModule() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedJ2EEWebModule(String instanceName, String applicationName, String moduleName)
        throws MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kWebModule, new String[]{instanceName, applicationName, moduleName});

    }

    public String[] getServlets() throws J2EEWebModuleException
    {
        ConfigMBeanNamingInfo namingInfo = this.getConfigMBeanNamingInfo();
        String [] locParams = namingInfo.getLocationParams();
        String applicationName = locParams[1];
        String moduleName      = locParams[2];

        try
        {
            J2eeApplication app = (J2eeApplication) this.getConfigBeanByXPath(ServerXPathHelper.getAppIdXpathExpression(applicationName));
            String location = app.getLocation();
            return ModulesXMLHelper.getServletsForWebModule(location, moduleName);
        }
        catch (Exception e)
        {
            sLogger.throwing(getClass().getName(), "getServlets", e);
            throw new J2EEWebModuleException(e.getMessage());
        }
    }

	public String[] getJSPPages() throws J2EEWebModuleException
    {
        return ( null );
    }


	public int getModuleType()
	{
		return (  AdminConstants.kTypeWebModule );
	}
    //all the other ias-web.xml parameters that are exposed.
}
