/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;

//Admin imports
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;

public class ManagedEjbContainer extends ConfigMBeanBase implements ConfigAttributeName.EjbContainer
{
 private static final String[][] MAPLIST  =  {
   { kMinBeansInPool,              ATTRIBUTE + ServerTags.STEADY_POOL_SIZE},
   { kBeanIncrementCount,          ATTRIBUTE + ServerTags.POOL_RESIZE_QUANTITY},
   { kMaxPoolSize,                 ATTRIBUTE + ServerTags.MAX_POOL_SIZE},
   { kCacheResizeQuantity,         ATTRIBUTE + ServerTags.CACHE_RESIZE_QUANTITY},
   { kMaxBeansInCache,             ATTRIBUTE + ServerTags.MAX_CACHE_SIZE},
   { kIdleInPoolTimeoutInSeconds,  ATTRIBUTE + ServerTags.POOL_IDLE_TIMEOUT_IN_SECONDS},
   { kIdleInCacheTimeoutInSeconds, ATTRIBUTE + ServerTags.CACHE_IDLE_TIMEOUT_IN_SECONDS},
   { kRemovalTimeoutInSeconds,     ATTRIBUTE + ServerTags.REMOVAL_TIMEOUT_IN_SECONDS},
   { kVictimSelectionAlgorithm,    ATTRIBUTE + ServerTags.VICTIM_SELECTION_POLICY},
   { kCommitOption,                ATTRIBUTE + ServerTags.COMMIT_OPTION },
//ms1   { kLogLevel,                    ATTRIBUTE + ServerTags.LOG_LEVEL},
   // { kMonitoringEnabled,           ATTRIBUTE + ServerTags.MONITORING_ENABLED }
 };

 private static final String[]   ATTRIBUTES  = {
   kMinBeansInPool                 + ",  int,     RW",
   kBeanIncrementCount             + ",  int,     RW",
   kMaxPoolSize                    + ",  int,     RW",
   kCacheResizeQuantity            + ",  int,     RW",
   kMaxBeansInCache                + ",  int,     RW",
   kIdleInPoolTimeoutInSeconds     + ",  int,     RW",
   kIdleInCacheTimeoutInSeconds    + ",  int,     RW",
   kRemovalTimeoutInSeconds        + ",  int,     RW",
   kVictimSelectionAlgorithm       + ",  String,  RW",
   kCommitOption                   + ",  String,  RW",
//ms1   kLogLevel                       + ",  String,  RW",
  // kMonitoringEnabled              + ",  boolean, RW",
 };

 private static final String[]   OPERATIONS  = null;
 
    /**
        Default constructor set MBean description tables
    */
    public ManagedEjbContainer() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    /**
        Constructs Config MBean for EjbContainer.
        @param instanceName The server instance name.
    */
    public ManagedEjbContainer(String instanceName) throws MBeanConfigException
    {
        this();
        initialize(ObjectNames.kEjbContainer, new String[]{instanceName});
    }
}
