/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.server.core.jmx;

public class ServiceName
{
    /** 
	Private constructor to avoid creation.
    */
    private ServiceName()
    {
    }
    /**
	The object name of the MBeanServer delegate object
	<BR>
	The value is <CODE>JMImplementation:type=MBeanServerDelegate</CODE>.
     */
    public static final String DELEGATE        = "JMImplementation:type=MBeanServerDelegate" ;
        
    /**
	The default domain.
	<BR>
	The value is <CODE>DefaultDomain</CODE>.
    */
    public static final String DOMAIN       = "DefaultDomain";

    /**
	The name of the JMX specification implemented by this product.    
	<BR>
	The value is <CODE>Java Management Extensions</CODE>.
    */
    public static final String JMX_SPEC_NAME = "Java Management Extensions";
    
    /**
	The version of the JMX specification implemented by this product.
	The value is <CODE>1.0 Final Release</CODE>.
    */
    public static final String JMX_SPEC_VERSION = "1.0 Final Release";
    
    /**
	The vendor of the JMX specification implemented by this product.     
	<BR>
	The value is <CODE>Sun Microsystems </CODE>.
    */
    public static final String JMX_SPEC_VENDOR = "Sun Microsystems";
    
    /**
     * The name of this product implementing the  JMX specification.
     * <BR>
     * The value is <CODE>iPlanet Application Server</CODE>.
     */
    public static final String JMX_IMPL_NAME = "iPlanet Application Server";
    
    /**
     * The name of the vendor of this product implementing the  JMX specification.  
     * <BR>
     * The value is <CODE>iPlanet</CODE>.
     */
    public static final String JMX_IMPL_VENDOR = "iPlanet";
    
    /**
     * The version of this product implementing the  JMX specification.  
     * <BR>
     * The value is <CODE>1.0</CODE>.
     */
    public static final String JMX_IMPL_VERSION = "7.0";

    /**
     * The build number of the current product version 
     */
    public static final String BUILD_NUMBER = "1";
}
