/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.enterprise.admin.common.constant.AdminConstants;

import java.util.Hashtable;

/**
    This class holds results for all instances in this admin server.
    The APIs in this class mirror ones in InstanceEnvironment.
    InstanceEnvironment actually checks timestamps, etc whereas this file
    gets it from cache and is significantly faster.
	@author  Sridatta
	@version 1.1
*/

public final class ManualChangeManager {
    /**
     * Logger for admin service
     */
    static Logger logger = Logger.getLogger(AdminConstants.kLoggerName);
    
    private static Hashtable result = new Hashtable();
            
    public static boolean hasHotChanged(String instance) {
         ManualChangeStatus mcs = (ManualChangeStatus)result.get(instance);
        if(mcs == null) return false; // not calculated yet. so return false
        
        return mcs.isChanged();
    }

    private static boolean hasHotInitChanged(String instanceName) {
        ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isInitFileChanged();
    }
    
    private static boolean hasHotRealmsKeyChanged(String instanceName) {
         ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isRealmsKeyFileChanged();
    }

    private static boolean hasHotObjectChanged(String instanceName) {
        ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isObjectFileChanged();
    }
    
    public static boolean hasHotXmlChanged(String instanceName) {
       ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isServerXmlFileChanged();
    }
    
    private static boolean hasHotMimeChanged(String instanceName) {
        ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isMimeFileChanged();
    }
    
    private static boolean hasHotVirtualServerConfFilesChanged(String instanceName) {
        ManualChangeStatus mcs = getManualChangeStatus(instanceName);
        if(mcs == null) return false;
        return mcs.isVirtualServerConfFilesChanged();
    }

    public static ManualChangeStatus getManualChangeStatus(String instance) {
        return (ManualChangeStatus) result.get(instance);
    }
    
    public static void removeManualChangeStatus(String instance) {
        result.remove(instance);
    }
    
    public static void removeServerXmlManualChangeStatus(String instance) {
        ManualChangeStatus m = getManualChangeStatus(instance);
        if(m != null) {
            m.setServerXmlFileChanged(false);
        }
    }
    
    public static void addManualChangeStatus(String instance, ManualChangeStatus mcs) {
        result.put(instance, mcs);
    }
}
