/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LogEvent.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import javax.management.MBeanServer;


/**
 *
 * @author hemanth
 */
public class LogEvent implements Event {
    private static StringManager sm = StringManager.getManager(LogEvent.class);
    private static Logger _logger=LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    
    /** Creates a new instance of LogEvent */
    public LogEvent( LogEventFilter filter , String description) {
        notificationFilter = filter;
        if (description != null)
            this.description = description;
        else
            description = defaultDescription;
    }
    
    public ObjectName getObjectName() {
        return getLogObjectName();
    }
    
    
    public String getType() {
        return "log";
    }
    
    public NotificationFilter getNotificationFilter( ){
        return notificationFilter;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void destroy() {
        // do nothing
    }
    
    static ObjectName getLogObjectName() {
        if (objName != null)
            return objName;
        try {
            objName =  new ObjectName( "amx:j2eeType=X-Logging,name="+
                    System.getProperty(SystemPropertyConstants.SERVER_NAME )+
                    ",X-ServerRootMonitor=" +
                    System.getProperty(SystemPropertyConstants.SERVER_NAME ));
            MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
            if (mbeanServer.isRegistered(objName)) {
                return objName;
            } else
                _logger.log(Level.WARNING,"smgt.internal_error",
                        new Object[] {sm.getString("selfmgmt_event.log_mbean_is_not_available")});
        }catch (MalformedObjectNameException mex) {
            _logger.log(Level.WARNING,"smgt.internal_error", mex);
        }
        return objName;
        
    }
    
    private static ObjectName objName = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.log_event_description");
    private static String description = null;
    private LogEventFilter notificationFilter = null;
}
