/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.monitor;

import java.io.Serializable;

import javax.management.JMException;
import javax.management.ObjectName;

/**
 * Monitoring Command. This is the super class of all monitoring commands.
 */
public abstract class MonitorCommand implements Serializable {

    /**
     * Constant to denote monitoring result attribute in event result.
     */
    public static final String MONITOR_RESULT = "monitor.result";

    /**
     * Object name for the MBean to which command applies.
     */
    protected ObjectName objectName;

    /**
     * Sub-types to which this command applies. If not null, the monitoring
     * command applies only to child MBeans of this type.
     */
    protected String monitoredObjectType;

    /**
     * Action Code. The sub-classes can use this to branch processing. 
     */
    protected int actionCode;

    /**
     * Run this command. The returned object should contain result of running
     * this command.
     * @throws JMXException if the command could not be run
     */
    abstract Object runCommand() throws JMException;

    /**
     * Get a string representation
     */
    public String toString() {
        return "MonitorCommand[ObjectName:" + objectName + ";Type:" + monitoredObjectType + ";ActionCode:" + actionCode + "]";
    }
}
