/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.server.core.AdminService;

/**
 * PE is a single server instance where domain administration server
 * and server runtime is co-located. This should always route to 
 * the PE instance.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public class PEEventDispatcher implements EventDispatcher {

    /**
     * Fortwards to the PE instance.
     */
    public AdminEventResult dispatch(AdminEvent event) {

        // always route to PE instance since it is the only running instance
        String peInstName  = AdminService.getAdminService().getInstanceName();
        event.setEffectiveDestination(peInstName);
        AdminEventResult r = AdminEventMulticaster.multicastEvent(event);

        return r;
    }
}
