/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.domains.registry;
import java.io.File;
import java.io.Serializable;
import java.io.IOException;


/**
   This class represents the data required to be registered for each
   domain so that invariants between domains can be maintained, and
   communication to domains established.
   <p>
   Instances of this class are immutable - they are simply data carriers.
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 */


public class DomainEntry implements Cloneable, Serializable
{

	  /**
		 Construct an immutable instance
		 @param name the name of the domain
		 @param root the root of the domain
		 @param contactData the data used to contact the domain
		 @throws NullPointerException if any argument is null
	  */
  public DomainEntry(String name, File root, ContactDataSet contactData) throws NullPointerException {
	if (name == null || root == null || contactData == null) {
	  throw new NullPointerException();
	}
	this.name = name;
	this.root = root;
        try
        {
	    this.path = root.getCanonicalPath();
        }
        catch(IOException ioe)
        {
	    this.path = root.getAbsolutePath();
        }	
	this.contactData = contactData;
  }

	  /**
		 Get the name of the receiver
		 @return the name of the receiver
	  */
  public String getName(){
	return this.name;
  }

	  /**
		 Get the root of the receiver
		 @return the root of the receiver
	  */
  public File getRoot(){
	return this.root;
  }

	  /**
		 Get the path of the receiver
		 @return the path of the receiver
	  */
  public String getPath(){
	return this.path;
  }

	  /**
		 Get the contact data of the receiver
		 @return the contact data of the receiver
	  */
  public ContactDataSet getContactData(){
	return this.contactData;
  }

  public Object clone() {
	try {
	  return super.clone();
	}
	catch (CloneNotSupportedException c){
	  return null;
	}
  }

  public int hashcode(){
	final String s = this.name+this.root.toString();
	return s.hashCode();
  }

  public boolean equals(Object rhs){
	return rhs != null && rhs instanceof DomainEntry && this.equals((DomainEntry) rhs);
  }

  private boolean equals(DomainEntry rhs){
	return rhs != null && this == rhs ||
	(this.name.equals(rhs.name) && this.root.equals(rhs.root));
  }

  private String name;
  private File root;
  private String path;
  private ContactDataSet contactData;
  
}
