/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

//JDK imports
import java.io.Serializable;



/**
	Base class for generic message exchange where messages are
	modeled as a list of parameters.  There is no explicit type
	to the message, just the list ParamList.
*/
public class Message implements Serializable
{
    public static long serialVersionUID = 1974497368816731621L;

	private ParamList		mParams = null;

        /**
            The default constructor.
        */
        
	public	Message()
	{
		mParams	= new ParamList();
	}

        /**
            Adds the given parameter in this Message.
        */
	public void addParam( Param param )
	{
		mParams.addParam( param );
	}

	public Param getParam( String name )
	{
		return( mParams.getParam( name ) );
	}


	// caller should not treat list as read-only
	/**
		Returns the list of Param objects. The list can be modified.
	 
		@return ParamList instance held by this Message.
	*/
	public ParamList getParamList()
	{
		return( mParams );
	}

	public String toString()
	{
		return( mParams.toString() );
	}
}