/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.distributed;

/**
 * An instance of DistributedReadOnlyBeanNotifier is used to notify other server 
 *  instances to refresh a ReadOnly Bean. An instance of 
 *  ReadOnlyBeanRefreshEventHandler is used to handle requests received from
 *  other server instances.
 *  
 *  @author Mahesh Kannan
 *  @see ReadOnlyBeanRefreshEventHandler
 */
public interface DistributedReadOnlyBeanNotifier {

    /**
     * This is called by the container after it has called refresh
     * 
     * @param ejbID the ejbID that uniquely identifies the container
     * @param pk The primary key of the bean(s) that is to be refreshed
     */
    public void notifyRefresh(long ejbID, byte[] pk);

    /**
     * This is called by the container after it has called refresh
     * 
     * @param ejbID the ejbID that uniquely identifies the container
     * @param pk The primary key of the bean(s) that is to be refreshed
     */
    public void notifyRefreshAll(long ejbID);

}
