/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import com.sun.ejb.containers.ReadOnlyEJBLocalHome;
import com.sun.ejb.containers.ReadOnlyEJBHome;

import java.util.logging.*;
import com.sun.logging.*;

import javax.ejb.EJBHome;

/**
 * Class that is used to obtain ReadOnlyBeanNotifier
 *  and ReadOnlyBeanLocalNotifier.
 *
 *  @deprecated New implementations must use com.sun.appserv.ejb.ReadOnlyBeanHelper
 *
 * @author Mahesh Kannan
 */
public class ReadOnlyBeanHelper {

    private static Logger _logger;
    private static final boolean debug = false;

    static {
        _logger=LogDomains.getLogger(LogDomains.EJB_LOGGER);
    }

    /**
     * Get a ReadOnlyBeanNotifier for a bean that can be "lookedup"
     *  using the ejbName
     * @returns a ReadOnlyBeanNotifier or null if the lookup 
     *  resulted in a NameNotFoundException
     */
    public static com.sun.ejb.ReadOnlyBeanNotifier
        getReadOnlyBeanNotifier(String ejbName)
    {
        try {
            Context ctx = new InitialContext();
            Object obj = ctx.lookup(ejbName);
            ReadOnlyEJBHome home = (ReadOnlyEJBHome) 
                PortableRemoteObject.narrow(obj, ReadOnlyEJBHome.class);
            return new ReadOnlyBeanNotifierImpl(home);
        } catch (Exception ex) {
            if(_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE,"ejb.remote_exception", ex);
            }
        }
        return null;
    }

    /**
     * Get a ReadOnlyBeanLocalNotifier for a bean that can be "lookedup"
     *  using the ejbName
     * @returns a ReadOnlyBeanLocalNotifier or null if the lookup 
     *  resulted in a NameNotFoundException
     */
    public static com.sun.ejb.ReadOnlyBeanLocalNotifier 
        getReadOnlyBeanLocalNotifier(String ejbName)
    {
        try {
            Context ctx = new InitialContext();
            ReadOnlyEJBLocalHome home = 
                (ReadOnlyEJBLocalHome) ctx.lookup(ejbName);
            return (com.sun.ejb.ReadOnlyBeanLocalNotifier)
                home.getReadOnlyBeanLocalNotifier();
        } catch (Exception ex) {
            if(_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE,"ejb.remote_exception",ex);
            }
        }
        return null;
    }

}
