/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.EJBStats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import com.sun.ejb.spi.stats.EJBStatsProvider;

/**
 * A Class for providing stats for EJB Container
 *  All S1AS(EJB)Containers act as the provider
 *
 * @author Mahesh Kannan
 */

public abstract class EJBStatsImpl
    extends StatsImpl
    implements javax.management.j2ee.statistics.EJBStats
{
    protected EJBStatsProvider delegate;

    private MutableCountStatisticImpl createStat;
    private MutableCountStatisticImpl removeStat;

    public EJBStatsImpl(EJBStatsProvider delegate, String intfName) {
	this.delegate = delegate;
	super.initialize(intfName);

	initStats();
    }

    private void initStats() {
	createStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("CreateCount"));
	removeStat = new MutableCountStatisticImpl(
	    new CountStatisticImpl("RemoveCount"));
    }

    public CountStatistic getCreateCount(){
	createStat.setCount(delegate.getCreateCount());
	return (CountStatistic) createStat.modifiableView();
    }

    public CountStatistic getRemoveCount(){
	removeStat.setCount(delegate.getRemoveCount());
	return (CountStatistic) removeStat.modifiableView();
    }

}
