/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.sfsb.store;

/**
 * FileStoreManagerConstants defines a set of "keys"
 * that can be used to populate / query values that
 * will be needed during SFSBStoreManager initialization.
 * 
 * FilePersistenceStragtegyBuilder populates the map with the
 *  following keys which is consumed by the FileStoreManager
 *
 * @author Mahesh Kannan
 */

public interface FileStoreManagerConstants {

    /**
     * Name of the store manager. Used mainly for logging / debugging
     */
    public static String STORE_MANAGER_NAME =
        "com.sun.ejb.spi.sfsb.store.name";

    /**
     * The containerId used to differentiate each container in 
     *	the server.
     */
    public static String CONTAINER_ID =
        "com.sun.ejb.spi.sfsb.store.containerid";

    /**
     * Defines the session timeout in seconds. Sessions not accessed
     *  for this duration can be removed and will no longer
     *  be available to clients
     */
    public static String SESSION_TIMEOUT_IN_SECONDS =
        "com.sun.ejb.spi.sfsb.store.timeout";

    /**
     * Defines the grace period for session timeout in seconds.
     *	Sessions not accessed for (SESSION_TIMEOUT_IN_SECONDS + thisValue)
     *  can be removed and will no longer be available to clients
     */
    public static String GRACE_SESSION_TIMEOUT_IN_SECONDS =
        "com.sun.ejb.spi.sfsb.store.grace.timeout";

    /**
    /**
     * This will be used by File system sfsbManager
     *  This param could be null
     */
    public static String PASSIVATION_DIRECTORY_NAME =
        "com.sun.ejb.spi.sfsb.store.directory";

}

