/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb;

import com.sun.enterprise.resource.ResourceHandle;
import java.lang.reflect.Method;

import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;

/**
 * MessageBeanProtocolManager is implemented by the MessageBeanContainer
 * and allows MessageBeanClients to create message bean listeners 
 * capable of receiving messages.  Each MessageBeanListener logically
 * represents a single message-driven bean instance, although there is
 * no guarantee as to exactly when the container creates that instance.
 * MessageBeanListeners are single-threaded.  Each MessageBeanListener is
 * held exclusively by a MessageBeanClient.
 *
 * @author Kenneth Saks
 */
public interface MessageBeanProtocolManager {

    /**
     * Create a MessageBeanListener.  
     *
     * @param resource handle associated with this listener.  can be null.
     * 
     * @throws Exception if the MessageBeanContainer was not able to create
     * the MessageBeanListener
     */
    MessageBeanListener createMessageBeanListener(ResourceHandle resourceHandle)
      throws ResourcesExceededException;

    /**
     * Return the MessageBeanListener to the container.  Since a
     * MessageBeanListener is typically associated with active resources
     * in the MessageBeanContainer, it is the responsibility of the 
     * MessageBeanClient to manage them judiciously.
     */ 
    void destroyMessageBeanListener(MessageBeanListener listener);


    /**
     * This is used by the message provider to find out whether message 
     * deliveries will be transacted or not. The message delivery preferences 
     * must not change during the lifetime of a message endpoint. This 
     * information is only a hint and may be useful to perform optimizations 
     * on message delivery.
     *
     * @param method One of the methods used to deliver messages, e.g.
     *               onMessage method for javax.jms.MessageListener.
     *               Note that if the <code>method</code> is not one 
     *               of the methods for message delivery, the behavior 
     *               of this method is not defined.
     */
    boolean isDeliveryTransacted (Method method) ;


    /**
     * Returns the message-bean container's pool properties. 
     */
    BeanPoolDescriptor getPoolDescriptor();  

}
