/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.alert;

import javax.management.NotificationFilter;
import javax.management.Notification;

/**
 * Class MailFilter by default filters out Warning messages.
 *
 * @AUTHOR: Hemanth Puttaswamy
 */
public class MailFilter implements NotificationFilter {

    private static String WARNING_LOG = "WarningLogMessages";

    // SEVERE and WARNING messages are sent out as alerts. This filter
    // is to filter out WARNING messages as Alerts as User by default
    // may not be interested in recieving WARNING as alerts over e-mail
    private boolean filterWarningMessages;

    /**
     * Zero arg constructor used by Alert Configuration Framework.
     */
    public MailFilter( ) {
        filterWarningMessages = true;
    }
  
    /**
     *  By Default Warning Log Messages are filtered out. If user is
     *  interested, filterWarningMessages can be set to false.
     */
    public void setFilterWarningMessages( boolean filter ) {
        filterWarningMessages = filter;
    }

    boolean getFilterWarningMessages( ) {
        return filterWarningMessages;
    }

    /**
     * Implementation of javax.management.NotificationFilter method.
     * Checks to see if WarningLogMessages need to be filtered or not.
     */
    public boolean isNotificationEnabled( Notification notification ) {
        if( !filterWarningMessages ) return true;
        return !notification.getType().equals( WARNING_LOG );
    }

    /**
     *  These are Unit Test Method provided for internal testing only.
     */
    public void setUnitTestData( String unitTestData ) {
        new UnitTest(
            UnitTest.UNIT_TEST_MAIL_FILTER, unitTestData, this ).start();
    }
}




