/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AppservClassLoader.java
 *
*/

package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.util.Hashtable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.MalformedURLException;


public class AppservClassLoader extends URLClassLoader {
    private Hashtable hashTable = new Hashtable(3); // small
    
    /** Creates new AppservClassLoader  _mapping is key=value;key=value....*/
    public AppservClassLoader() throws MalformedURLException, RuntimeException {
        super(new URL[0], AppservClassLoader.class.getClassLoader());
    }
    
    public void addURL(File f) throws MalformedURLException, RuntimeException {
            if (f.isFile()){
                addURL(f.toURI().toURL());
              ///  System.out.println("adding file  = "+f.getAbsolutePath());
              ///  System.out.println("adding file  exists= "+f.exists() );
            }
            else{
              ///  System.out.println("file does not exist!!! = "+f.getAbsolutePath());
            }
    }


    public static AppservClassLoader getClassLoader() {
        
        AppservClassLoader loader = null;

        try {
            loader = new AppservClassLoader();
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            if (installRoot == null) {
                    //set installRoot to current directory
                installRoot = ".";
            }

            File f;
            
            final String classpathPrefix = System.getProperty("com.sun.ant.classpath.prefix");
            if (classpathPrefix != null) {
                f = new File(classpathPrefix);
                loader.addURL(f);
            }

            final String derbyRoot = System.getProperty("derby.root");
            if (derbyRoot != null) {
                //set derby jar file
                f = new File (derbyRoot+"/lib/derby.jar");
                loader.addURL(f);
            }
            
            f = new File(installRoot+"/lib");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-ws.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-se.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-admin.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-ext.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-rt.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/appserv-cmp.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/admin-cli.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/commons-launcher.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/javaee.jar");
            loader.addURL(f);
            f = new File(installRoot+"/lib/install/applications/jmsra/imqjmsra.jar");
            loader.addURL(f);
        }catch (Exception ex) {
            ex.printStackTrace();
                //throw new Exception(ex2.getLocalizedMessage());
        }
        return loader;
    }

}
