/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package org.apache.tools.ant.taskdefs.optional.iplanet;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.BuildException;

import java.io.File;

public class DeployTask extends ComponentAdmin {
	private static final String DEPLOY_COMMAND = "deploy";

	protected void checkComponentConfig(Component comp) throws BuildException {
		super.checkComponentConfig(comp);

		// file must exist (either directory or file)
		File theFile = comp.getFile();
		if ((theFile == null) || (!theFile.exists())) {
			String msg = "The file specified (" + theFile + ") could not be found.";
			throw new BuildException(msg, getLocation());
		}

		// contextroot only makes sense when deploying web components
		String theType = comp.getType();
		if ((theType != null) && (!theType.equals(TYPE_WEB)) && (comp.contextRootIsSet())) {
			String msg = "The \"contextroot\" attribute doesn't apply to "
							+ comp.getType() + " files -- it only applies to war files.";
			log(msg, Project.MSG_WARN);
		}
	}

	protected String getCommandString(Server server, Component comp) {
		StringBuffer cmdString = new StringBuffer(DEPLOY_COMMAND);
		cmdString.append(server.getCommandParameters(true));
		if (comp.getType() != null) {
			cmdString.append(" --type ").append(comp.getType());
			if (comp.getType().equals(TYPE_WEB)) {
				cmdString.append(" --contextroot ").append(comp.getContextroot());
			}
		}

		cmdString.append(" --force=").append(comp.getForce());
		cmdString.append(" --name ").append(comp.getName());
		cmdString.append(" --upload=").append(comp.getUpload());
		cmdString.append(" ").append(comp.getFile().getPath());

		return cmdString.toString();
	}
}