/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.util;

import java.util.EventObject;
import java.util.Hashtable;

    /** Generic event for notifications.
    * @author Danny Coward
    */

public class NotificationEvent extends EventObject {

    public static String OBJECT_THAT_CHANGED = "ObjectThatChanged";
    public static String ATTRIBUTE_THAT_CHANGED = "AttributeThatChanged";

    private String type = null;
    protected Hashtable properties = new Hashtable();
    
    public NotificationEvent(Object source, String type) {
	super(source);
	this.type = type;
    }
    
    public NotificationEvent(Object source, String type, String name, Object value) {
	super(source);
	this.type = type;
	this.properties.put(name, value);
    }
    
    public NotificationEvent(Object source, String type, Object objectThatChanged) {
	super(source);
	this.type = type;
	this.properties.put(OBJECT_THAT_CHANGED, objectThatChanged);
    }
        
    public NotificationEvent(Object source, String type, Object objectThatChanged, Object attribThatChanged) {
	this(source, type, objectThatChanged);
	if (attribThatChanged != null) {
	    this.properties.put(ATTRIBUTE_THAT_CHANGED, attribThatChanged);
	}
    }

    public String getType() {
	return this.type;
    }
    
    public Object getValue(String name) {
	return this.properties.get(name);
    }
    
    public Object getObjectThatChanged() {
	return this.properties.get(OBJECT_THAT_CHANGED);
    }
        
    public Object getAttributeThatChanged() {
	return this.properties.get(ATTRIBUTE_THAT_CHANGED);
    }

}
