/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.io.InputStream;
import java.io.FileInputStream;
import java.io.File;

public class JarEntrySource {
    public JarEntrySource(File file) {
	this.markOnly = false;
	this.name = file.getPath().replace(File.separatorChar, '/');
	this.file = file;
    }

    public JarEntrySource(String name, File file) {
	this.markOnly = false;
	this.name = name;
	this.file = file;
    }

    public JarEntrySource(String name, InputStream is) {
	this.markOnly = false;
	this.name = name;
	this.is = is;
    }

    public JarEntrySource(String name) {
	this.markOnly = true;
	this.name = name;
    }
    /**
     * Accessors
     */
    public boolean isMarkOnly() {
	return markOnly;
    }

    public long getTime() {
	if (file != null) {
	    return file.lastModified();
	} else {
	    return 0;		// ??
	}
    }

    public long getLength() {
	if (file != null) {
	    return file.length();
	} else {
	    return 0;		// ??
	}
    }

    public String getName() {
	return name;
    }

    public InputStream getInputStream() {
	if (file != null) {
	    try {
		return new FileInputStream(file);
	    } catch (Exception ex) {
		return null;
	    }
	} else {
	    return is;
	}
    }

    private boolean markOnly;	// only mark in the ZIP
    private String name;	// the name of this entry
    private InputStream is;	// the input stream for the entry
    private File file;		// if a file
    private long modifiedTime;	// if an inputstream

    public String toString() {
	return file == null ? getName() : file.toString();
    }
}
