/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.web;

import java.util.Set;
import java.util.List;

/** Servlet filter objects */
public interface ServletFilterMapping {

    public static String TARGET_TYPE_URLPATTERN = "URLPattern";
    public static String TARGET_TYPE_SERVLET    = "Servlet";

    public static String INCLUDE = "INCLUDE";
    public static String REQUEST = "REQUEST";
    public static String FORWARD = "FORWARD";

    public void setName(String name);
    public String getName();

    public void setTargetType(String type);
    public String getTargetType();
    public boolean isURLPatternTarget();
    public boolean isServletNameTarget();

    public void setTarget(String type);
    public String getTarget();

    public void addDispatcher(String dispatcher);
    public Set getDispatchers();

    public void addURLPattern(String urlPattern);
    public List<String> getURLPatterns();
    public void addServletName(String servletName);
    public List<String> getServletNames();
}
