/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.common;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import java.util.ArrayList;
import java.util.List;

/**
 * This is the in memory representation of the security-role-mapping
 * information.  Note that we are keeping just the literal Strings
 * in this object.  The implementation of Principal is not instantiated
 * here.  This is because 1) the dol should avoid loading any classes
 * as the classloaders used for deployment and runtime can be different.
 * 2) verifier uses this information and it has not access to the rolemaper
 * on the server.
 *
 * @author Jerome Dochez
 */
public class SecurityRoleMapping extends RuntimeDescriptor {

    private String roleName = null; //mandatory element
    private List<PrincipalNameDescriptor> principals = 
                        new ArrayList<PrincipalNameDescriptor>();
    private List<String> groups = new ArrayList<String>();

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String name) {
        roleName = name;
    }

    public List<PrincipalNameDescriptor> getPrincipalNames() {
        return principals; 
    }

    public void addPrincipalName(PrincipalNameDescriptor p) {
        principals.add(p);
    }

    public List<String> getGroupNames() {
        return groups;
    }

    public void addGroupName(String g) {
        groups.add(g);
    }

    /**
     *@deprecated 
     *This method needs to be removed once the custom principal is fully 
     *supported. We keep it for now for backward compatiblity in API.  Note
     *that this method only returns the name of the principals, not their
     *class-names.  Use with caution!
     */
    public String[] getPrincipalName() {
        String[] names = new String[principals.size()];
        for (int i = 0; i < principals.size(); i++) {
            names[i] = new String(principals.get(i).getName());
        }
        return names;
    }
}
