/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.common;

import java.util.ArrayList;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

public class MessageSecurityDescriptor extends RuntimeDescriptor {
    public static final String MESSAGE = "Message";
    public static final String REQUEST_PROTECTION = "RequestProtection";
    public static final String RESPONSE_PROTECTION = "ResponseProtection";

    private ArrayList messageDescs = new ArrayList();
    private ProtectionDescriptor requestProtectionDesc = null;
    private ProtectionDescriptor responseProtectionDesc = null;

    public MessageSecurityDescriptor() {}

    public void addMessageDescriptor(MessageDescriptor messageDesc) {
       messageDescs.add(messageDesc);
    }
    
    public ArrayList getMessageDescriptors() {
        return messageDescs;
    }

    public ProtectionDescriptor getRequestProtectionDescriptor() {
        return requestProtectionDesc;
    }

    public void setRequestProtectionDescriptor(ProtectionDescriptor proDesc) {
        requestProtectionDesc = proDesc;
    }

    public ProtectionDescriptor getResponseProtectionDescriptor() {
        return responseProtectionDesc;
    }

    public void setResponseProtectionDescriptor(ProtectionDescriptor proDesc) {
        responseProtectionDesc = proDesc;
    }

    // return all the methods defined in the message elements inside this 
    // message-security element
    public ArrayList getAllMessageMethods() {
        //FIXME
        // need to convert operation to message
        // need to union all the methods
        return new ArrayList();
    }

}
