/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime;

import java.util.ArrayList;
import java.util.Set;
import java.util.Iterator;
import java.util.Vector;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;

public class FlushAtEndOfMethodDescriptor extends Descriptor{

    private ArrayList methodDescs = new ArrayList();
    private ArrayList convertedMethodDescs = new ArrayList();
    private EjbDescriptor ejbDescriptor = null;

    /** Default constructor. */
    public FlushAtEndOfMethodDescriptor() {
    }

     /**
      * Getter for method
      * @return Value of MethodDescriptor list
      */
    public ArrayList getMethodDescriptors() {
        return methodDescs;
    }

     /**
      * Getter for converted method
      * @return Value of style converted MethodDescriptor list
      */
    public ArrayList getConvertedMethodDescs() {
       if (convertedMethodDescs.isEmpty()) {
           convertStyleFlushedMethods();
       } 
       return convertedMethodDescs;
    }


    /**
      * Getter for ejbDescriptor
      * @return Value of ejbDescriptor
      */
    public EjbDescriptor getEjbDescriptor() {
        return ejbDescriptor;
    }

    /**
     * Setter for ejbDescriptors
     * @param ejbDescriptors New value of ejbDescriptor.
     */
    public void setEjbDescriptor(
        EjbDescriptor ejbDescriptor) {
        this.ejbDescriptor = ejbDescriptor;
    }


    /**
     * Setter for method
     * @param MethodDescriptor New value of MethodDescriptor to add.
     */
    public void addMethodDescriptor(MethodDescriptor methodDesc) {
        methodDescs.add(methodDesc);
    }

    private void convertStyleFlushedMethods() {
        Set allMethods = ejbDescriptor.getMethodDescriptors();
        for (Iterator mdItr = methodDescs.iterator(); mdItr.hasNext();) {
            MethodDescriptor methodDesc = (MethodDescriptor) mdItr.next();
 
            // the ejb-name element defined in the method element will
            // be always ignored and overriden by the one defined in 
            // ejb element
            methodDesc.setEjbName(ejbDescriptor.getName());

            // Convert to style 3 method descriptors
            Vector mds = methodDesc.doStyleConversion(ejbDescriptor, allMethods);
            convertedMethodDescs.addAll(mds); 
        }
    }

    public boolean isFlushEnabledFor(MethodDescriptor methodDesc) {
        return getConvertedMethodDescs().contains(methodDesc);
    }
}
