/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import java.util.Map;
import java.util.HashMap;
import java.util.logging.Level;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.IASPersistenceManagerDescriptor;
import com.sun.enterprise.deployment.runtime.PersistenceManagerInUse;
import com.sun.enterprise.deployment.runtime.web.Servlet;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

// all registered descriptors
import com.sun.enterprise.deployment.runtime.common.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.runtime.common.EjbRef;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.ResourceEnvRef;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.connector.MapElement;
import com.sun.enterprise.deployment.runtime.connector.Principal;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.RoleMap;
import com.sun.enterprise.deployment.runtime.web.Cache;
import com.sun.enterprise.deployment.runtime.web.CacheHelper;
import com.sun.enterprise.deployment.runtime.web.CacheMapping;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.deployment.runtime.web.ConstraintField;
import com.sun.enterprise.deployment.runtime.web.CookieProperties;
import com.sun.enterprise.deployment.runtime.web.DefaultHelper;
import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.runtime.web.WebProperty;

/**
 * This class is responsible for instanciating  runtime Descriptor classes
 *
 * @author  Jerome Dochez
 * @version 
 */
public class RuntimeDescriptorFactory {

    
    static Map descriptorClasses;
    
    /** This is a factory object no need for DescriptorFactory instance */
    protected RuntimeDescriptorFactory() {
    }

    private static void initMapping() {
        descriptorClasses = new HashMap();    
	
	// WEB
        register(new XMLElement(RuntimeTagNames.PROPERTY), WebProperty.class);
	register(new XMLElement(RuntimeTagNames.COOKIE_PROPERTIES), CookieProperties.class);
	register(new XMLElement(RuntimeTagNames.LOCALE_CHARSET_MAP), LocaleCharsetMap.class);
	register(new XMLElement(RuntimeTagNames.LOCALE_CHARSET_INFO), LocaleCharsetInfo.class);
	register(new XMLElement(RuntimeTagNames.MANAGER_PROPERTIES), ManagerProperties.class);
	register(new XMLElement(RuntimeTagNames.SERVLET), Servlet.class);
	register(new XMLElement(RuntimeTagNames.SESSION_CONFIG), SessionConfig.class);	
	register(new XMLElement(RuntimeTagNames.SESSION_MANAGER), SessionManager.class);
	register(new XMLElement(RuntimeTagNames.JSP_CONFIG), JspConfig.class);
	register(new XMLElement(RuntimeTagNames.CACHE_MAPPING), CacheMapping.class);
	register(new XMLElement(RuntimeTagNames.CACHE_HELPER), CacheHelper.class);
	register(new XMLElement(RuntimeTagNames.CACHE), Cache.class);
	register(new XMLElement(RuntimeTagNames.CLASS_LOADER), ClassLoader.class);
	register(new XMLElement(RuntimeTagNames.STORE_PROPERTIES), StoreProperties.class);	
	register(new XMLElement(RuntimeTagNames.SESSION_PROPERTIES), SessionProperties.class);
	register(new XMLElement(RuntimeTagNames.DEFAULT_HELPER), DefaultHelper.class);
	register(new XMLElement(RuntimeTagNames.EJB_REF), EjbRef.class);
        register(new XMLElement(RuntimeTagNames.RESOURCE_REF), ResourceRef.class);
        register(new XMLElement(RuntimeTagNames.RESOURCE_ENV_REF), ResourceEnvRef.class);        
        register(new XMLElement(RuntimeTagNames.DEFAULT_RESOURCE_PRINCIPAL), DefaultResourcePrincipal.class);
        register(new XMLElement(RuntimeTagNames.CONSTRAINT_FIELD), ConstraintField.class);
        
        // EJB
        register(new XMLElement(RuntimeTagNames.PM_DESCRIPTOR), IASPersistenceManagerDescriptor.class);
        register(new XMLElement(RuntimeTagNames.PM_INUSE), PersistenceManagerInUse.class);
        
	// connector related
	register(new XMLElement(RuntimeTagNames.PRINCIPAL), Principal.class);
	register(new XMLElement(RuntimeTagNames.BACKEND_PRINCIPAL), Principal.class);
	register(new XMLElement(RuntimeTagNames.MAP_ELEMENT), MapElement.class);
	register(new XMLElement(RuntimeTagNames.ROLE_MAP), RoleMap.class);
	register(new XMLElement(RuntimeTagNames.RESOURCE_ADAPTER), ResourceAdapter.class);	

        //common
        register(new XMLElement(RuntimeTagNames.PRINCIPAL_NAME), PrincipalNameDescriptor.class);
        register(new XMLElement(RuntimeTagNames.SECURITY_ROLE_MAPPING), SecurityRoleMapping.class);
     }
    /**
     * register a new descriptor class handling a particular XPATH in the DTD. 
     *
     * @param xmlPath absolute or relative XPath
     * @param clazz the descriptor class to use
     */
    public static void register(XMLElement  xmlPath, Class clazz) {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {        
            DOLUtils.getDefaultLogger().fine("Register " + clazz + " to handle " + xmlPath.getQName());
        }
	descriptorClasses.put(xmlPath.getQName(), clazz);
    }
    
    /**
     * @return the descriptor tag for a particular XPath
     */
    public static Class getDescriptorClass(String xmlPath) {
        String s = xmlPath;        
        do {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {            
                DOLUtils.getDefaultLogger().finer("looking for " + xmlPath + " in " + descriptorClasses);
            }
            if (descriptorClasses.containsKey(xmlPath)) {
                return (Class) descriptorClasses.get(xmlPath);            
            }
            if (xmlPath.indexOf('/')!=-1) {
                xmlPath = xmlPath.substring(xmlPath.indexOf('/')+1);
            } else {
                xmlPath=null;
            }            
        } while (xmlPath!=null);

	if(DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("No descriptor registered for " + s);
	}
        return null;
    }
    
    /**
     * @return a new instance of a registered descriptor class for the 
     * supplied XPath
     */
    public static Object  getDescriptor(String xmlPath) {        
        
        try {
            Class c = getDescriptorClass(xmlPath);
	    if (c!=null) {
                return c.newInstance();
            }
        } catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
            
    static {
        initMapping();
    }     
}
