/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SecurityRoleRefNode.java
 *
 * Created on January 24, 2002, 4:57 PM
 */

package com.sun.enterprise.deployment.node;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.xml.EjbTagNames;

/**
 * This class handles the DD xml security-role-ref tag
 *
 * @author  Jerome Dochez
 * @version 
 */
public class SecurityRoleRefNode extends DeploymentDescriptorNode {
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(EjbTagNames.ROLE_NAME, "setName");
        table.put(EjbTagNames.ROLE_LINK, "setValue");            
        return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element for this DOM tree fragment
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {    
        if (! (descriptor instanceof RoleReference)) {
            throw new IllegalArgumentException(getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }    
        RoleReference roleRef = (RoleReference) descriptor;        
        Node subNode = super.writeDescriptor(parent, nodeName, roleRef);

        writeLocalizedDescriptions(subNode, descriptor);        

        appendTextChild(subNode, EjbTagNames.ROLE_NAME, roleRef.getName());                   
        appendTextChild(subNode, EjbTagNames.ROLE_LINK, roleRef.getValue());                  
        return subNode;
    }
}
