/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.deploy.shared;

import java.io.OutputStream;
import java.io.IOException;

/**
 * This interface is an abtraction for writing entries to an
 * archive
 *
 * @author Jerome Dochez
 */
public interface WritableArchive extends Archive {
    
    /**
     * Begins writing a new entry to this archive 
     * with the entry name. The output stream returned 
     * can be used until closeEntry() is called
     * 
     * @param name is the new archive entry name
     * @return an output stream to use to write the entry
     * to the archive
     */
    public OutputStream putNextEntry(String name) throws IOException;
    
    /**
     * Closes the current entry 
     */
    public void closeEntry() throws IOException;
    
    
}
