/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.annotation.security.RunAs;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;

/**
 * This handler is responsible for handling the
 * javax.annotation.security.RunAs.
 * @author Shing Wai Chan
 */
public class RunAsHandler extends AbstractCommonAttributeHandler {
    
    public RunAsHandler() {
    }
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType() {
        return RunAs.class;
    }

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
            EjbContext[] ejbContexts) throws AnnotationProcessorException {
        
        RunAs runAsAn = (RunAs)ainfo.getAnnotation();

        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            // override by xml
            if (ejbDesc.getUsesCallerIdentity() != null) {
                continue;
            }
            String roleName = runAsAn.value();
            Role role = new Role(roleName);
            // add Role if not exists
            ejbDesc.getEjbBundleDescriptor().addRole(role);
            RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
            runAsDesc.setRoleName(roleName);
            ejbDesc.setUsesCallerIdentity(false);
            if (ejbDesc.getRunAsIdentity() == null) {
                ejbDesc.setRunAsIdentity(runAsDesc);
            }
        }

        return getDefaultProcessedResult();
    }

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
            WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        RunAs runAsAn = (RunAs)ainfo.getAnnotation();

        for (WebComponentContext webCompContext : webCompContexts) {
            WebComponentDescriptor webDesc = webCompContext.getDescriptor();
            // override by xml
            if (webDesc.getRunAsIdentity() != null) {
                continue;
            }
            String roleName = runAsAn.value();
            Role role = new Role(roleName);
            // add Role if not exists
            webDesc.getWebBundleDescriptor().addRole(role);
            RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
            runAsDesc.setRoleName(roleName);
            webDesc.setRunAsIdentity(runAsDesc);
        }

        return getDefaultProcessedResult();
    }

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
             WebBundleContext webBundleContext)
             throws AnnotationProcessorException {
        return getInvalidAnnotatedElementHandlerResult(
            ainfo.getProcessingContext().getHandler(), ainfo);
    }


    public Class<? extends Annotation>[] getTypeDependencies() {
        return getEjbAnnotationTypes();
    }
}
