/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.factory;

import java.util.HashSet;
import java.util.Set;

import com.sun.enterprise.deployment.annotation.AnnotationHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessor;
import com.sun.enterprise.deployment.annotation.handlers.*;
import com.sun.enterprise.deployment.annotation.impl.AnnotationProcessorImpl;

/**
 * This factory is responsible for initializing a ready to use
 * AnnotationProcessor. 
 *
 * @author Shing Wai Chan
 */
public class SJSASFactory extends Factory {
    private static Set<String> annotationClassNames = new HashSet<String>();

    private SJSASFactory() {
    }

    public static AnnotationProcessor getAnnotationProcessor() {
        init();
        return Factory.getAnnotationProcessor();
    }

    public static Set<String> getAnnotations() {
        init();
        return (HashSet)((HashSet)annotationClassNames).clone();
    }

    private static void init() {
        if (systemProcessor == null) {
            synchronized(Factory.class) {            
                if (systemProcessor == null) {
                    // initialize our system annotation processor...            
                    systemProcessor = new AnnotationProcessorImpl();
                    for (AnnotationHandler anHandler : getSystemAnnotationHandlers()) {
                        systemProcessor.pushAnnotationHandler(anHandler); 
                        annotationClassNames.add("L" +
                            anHandler.getAnnotationType().getName().
                            replace('.', '/') + ";");
                    }
                }
            }
        }

    }

    private static AnnotationHandler[] getSystemAnnotationHandlers() {
        return new AnnotationHandler[] {
                new DenyAllHandler(),
                new ApplicationExceptionHandler(),
                new AroundInvokeHandler(),
                new DeclareRolesHandler(),
                new EntityManagerFactoryReferenceHandler(),
                new EntityManagerFactoryReferencesHandler(),
                new EntityManagerReferenceHandler(),
                new EntityManagerReferencesHandler(),
                new ExcludeClassInterceptorsHandler(),
                new ExcludeDefaultInterceptorsHandler(),
                new EJBHandler(),
                new EJBsHandler(),
                new HandlerChainHandler(),                        
                new InitHandler(),
                new InterceptorsHandler(),
                new MessageDrivenHandler(),
                new PermitAllHandler(),
                new PostActivateHandler(),
                new PostConstructHandler(),
                new PreDestroyHandler(),
                new PrePassivateHandler(),
                new ResourceHandler(),
                new RolesAllowedHandler(),
                new ResourcesHandler(),
                new RemoveHandler(),
                new RunAsHandler(),
                new StatefulHandler(),
                new StatelessHandler(),
                new TimeoutHandler(),    
                new TransactionAttributeHandler(),
                new TransactionManagementHandler(),
                new WebServiceHandler(),
                new WebServiceProviderHandler(),
		new WebServiceRefHandler(),
		new WebServiceRefsHandler()
        };
    }
}
