/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.types.EjbReference;

/**
 * Objects implementing this interface allow their
 * environment properties, ejb references and resource
 * references to be written.
 * 
 * @author Danny Coward
 */

public interface WritableJndiNameEnvironment extends JndiNameEnvironment {

    /**  
     * Adds the specified environment property to the receiver.
     *   
     * @param environmentProperty the EnvironmentProperty to add.  
     *
     */
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty);
    
    /**  
     * Removes the specified environment property from receiver.
     *   
     * @param environmentProperty the EnvironmentProperty to remove.  
     *
     */
    public void removeEnvironmentProperty(
			EnvironmentProperty environmentProperty);
    
    /**  
     * Adds the specified ejb reference to the receiver.
     *   
     * @param ejbReference the EjbReferenceDescriptor to add.  
     *
     */
    public void addEjbReferenceDescriptor(EjbReference ejbReference);
    
    /**  
     * Removes the specificed ejb reference from the receiver.
     *   
     * @param ejbReference the EjbReferenceDescriptor to remove.  
     *
     */
    public void removeEjbReferenceDescriptor(
			EjbReference ejbReference);
    
    /**  
     * Adds the specified resource reference to the receiver.
     *   
     * @param resourceReference the ResourceReferenceDescriptor to add.  
     *
     */
    public void addResourceReferenceDescriptor(
			ResourceReferenceDescriptor resourceReference);
    
    /**  
     * Removes the specified resource reference from the receiver.
     *   
     * @param resourceReference the ResourceReferenceDescriptor to remove.  
     *
     */
    public void removeResourceReferenceDescriptor(
			ResourceReferenceDescriptor resourceReference);


    /**  
     * Adds the specified JMS destination reference to the receiver.
     *   
     * @param the JmsDestinationReferenceDescriptor to add.  
     *
     */
    public void addJmsDestinationReferenceDescriptor(
		JmsDestinationReferenceDescriptor jmsDestinationReference);


    /**  
     * Removes the specified JMS destination reference from the receiver.
     *   
     * @param the JmsDestinationReferenceDescriptor to remove.
     *
     */
    public void removeJmsDestinationReferenceDescriptor(
		JmsDestinationReferenceDescriptor jmsDestinationReference);

    /**  
     * Adds the specified message destination reference to the receiver.
     *   
     * @param the MessageDestinationReferenceDescriptor to add.  
     *
     */
    public void addMessageDestinationReferenceDescriptor
        (MessageDestinationReferenceDescriptor msgDestRef);

    /**  
     * Removes the specified message destination reference from the receiver.
     *   
     * @param ref MessageDestinationReferenceDescriptor to remove.
     *
     */
    public void removeMessageDestinationReferenceDescriptor
        (MessageDestinationReferenceDescriptor msgDestRef);
                                                         
    /** 
     * Adds the specified post-construct descriptor to the receiver.
     *  
     * @param the post-construct LifecycleCallbackDescriptor to add.
     *
     */
    public void addPostConstructDescriptor
        (LifecycleCallbackDescriptor postConstructDesc);

    /** 
     * Adds the specified pre-destroy descriptor to the receiver.
     *  
     * @param the pre-destroy LifecycleCallbackDescriptor to add.
     *
     */
    public void addPreDestroyDescriptor
        (LifecycleCallbackDescriptor preDestroyDesc);

    /**  
     * Adds the specified service reference to the receiver.
     *   
     * @param the ServiceReferenceDescriptor to add.  
     *
     */
    public void addServiceReferenceDescriptor(
	        ServiceReferenceDescriptor serviceReference);


    /**  
     * Removes the specified service reference from the receiver.
     *   
     * @param the ServiceReferenceDescriptor to remove.
     *
     */
    public void removeServiceReferenceDescriptor(
		ServiceReferenceDescriptor serviceReference);     

    public void addEntityManagerFactoryReferenceDescriptor(
                EntityManagerFactoryReferenceDescriptor reference);

    public void addEntityManagerReferenceDescriptor(
                EntityManagerReferenceDescriptor reference);



}

