/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;

import java.util.*;


    /** 
    * Objects exhibiting this interface represent a security constraint on the web application
    * that owns them. 
    * @author Danny Coward
    */

public class SecurityConstraintImpl extends Descriptor implements SecurityConstraint, java.io.Serializable {
    private Set webResourceCollections;
    private AuthorizationConstraint authorizationConstraint;
    private UserDataConstraint userDataConstraint;
    
    /** Default constructor.*/
    public SecurityConstraintImpl() {
    
    }
    
    /** Copy constructor.*/
    public SecurityConstraintImpl(SecurityConstraintImpl other) {
	this.webResourceCollections = new HashSet(other.webResourceCollections);
	if (other.authorizationConstraint != null) {
	    this.authorizationConstraint = new AuthorizationConstraintImpl((AuthorizationConstraintImpl) other.authorizationConstraint);
	}
	if (other.userDataConstraint != null) {
	    this.userDataConstraint = new UserDataConstraintImpl();
	    this.userDataConstraint.setTransportGuarantee(other.userDataConstraint.getTransportGuarantee());
	}
    }
    
    
    /** Return all the web resource collection.
    */
    public Set getWebResourceCollectionSet() {
	if (this.webResourceCollections == null) {
	    this.webResourceCollections = new HashSet();
	}
	return this.webResourceCollections;
    }
    
	/** The collection of URL pattern plus HTTP methods that are constrained. */
    public Enumeration getWebResourceCollections() {
	return (new Vector(this.getWebResourceCollectionSet())).elements();
    }
    
    /** Adds a web resource collection to this constraint.*/
    public void addWebResourceCollection(WebResourceCollection webResourceCollection) {
	this.getWebResourceCollectionSet().add(webResourceCollection);
    }
    
    public void addWebResourceCollection(WebResourceCollectionImpl webResourceCollection) {    
        addWebResourceCollection((WebResourceCollection) webResourceCollection);
    }
    
    /** Removes the given web resource collection from this constraint.*/
    public void removeWebResourceCollection(WebResourceCollection webResourceCollection) {
	this.getWebResourceCollectionSet().remove(webResourceCollection);
    }
    
	/** The authorization constraint. */
    public AuthorizationConstraint getAuthorizationConstraint() {
	return this.authorizationConstraint;
    }
    
    /** Sets the authorization constraint.*/
    public void setAuthorizationConstraint(AuthorizationConstraint authorizationConstraint) {
	this.authorizationConstraint = authorizationConstraint;
    }
    
    /** Sets the authorization constraint.*/
    public void setAuthorizationConstraint(AuthorizationConstraintImpl authorizationConstraint) {
	setAuthorizationConstraint((AuthorizationConstraint) authorizationConstraint);
    }
    
	/** The user data constraint. */
    public UserDataConstraint getUserDataConstraint() {
	return this.userDataConstraint;
    }
	/** Sets the user data constraint. */
    public void setUserDataConstraint(UserDataConstraint userDataConstraint) {
	this.userDataConstraint = userDataConstraint;
    }
    
    public void setUserDataConstraint(UserDataConstraintImpl userDataConstraint) {
	setUserDataConstraint((UserDataConstraint) userDataConstraint);
    }
    
    /** Returns a formatted String representing of my state.*/
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("SecurityConstraint: ");
	toStringBuffer.append(" webResourceCollections: ").append(webResourceCollections);
	toStringBuffer.append(" authorizationConstraint ").append(authorizationConstraint);
	toStringBuffer.append(" userDataConstraint ").append(userDataConstraint);
    
    }
    
}
