/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.*;

/**
 * This is a descriptor for the taglib config used in a web application.
 */
public class JspConfigDescriptor extends Descriptor {
    
    private Set list = null;
    private Vector jspGroups = null;
    /**
     * return the set of tag lib elements
     */
    public Set getTagLibSet() {
	if(list == null) {
	    list = new HashSet();
	}
	return list;
    }

    /**
     * return the enumeration of tag lib elements
     */
    public Enumeration getTagLibs() {
	return (new Vector(this.getTagLibSet())).elements();
    }

    /**
     * add a tag lib element to the set.
     */
    public void addTagLib(TagLibConfigurationDescriptor desc) {
	getTagLibSet().add(desc);
        changed();
    }

    /**
     * remove a tag lib element from the set.
     */
    public void removeTagLib(TagLibConfigurationDescriptor desc) {
	getTagLibSet().remove(desc);
        changed();
    }

    /**
     * return the set of jsp-group elements 
     */
    public Collection getJspGroupSet() {
	if(jspGroups == null) {
	    jspGroups = new Vector();
	}
	return jspGroups;
    }

    /**
     * return the enumeration of jsp-group elements 
     */
    public Enumeration getJspGroups() {
	return (new Vector(getJspGroupSet())).elements();
    }

    /**
     * add a jsp group element to the set.
     */
    public void addJspGroup(JspGroupDescriptor desc) {
	getJspGroupSet().add(desc);
        changed();
    }

    /**
     * remove a jsp group element from the set.
     */
    public void removeJspGroup(JspGroupDescriptor desc) {
	getJspGroupSet().remove(desc);
        changed();
    }

    /**
     * @return a string describing the values I hold
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\nTagLibs : ").append(list).append(" jsp groups:").append(jspGroups);
    }
}
