/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 *NMTransportFactory.java
 *
 * Created on May 4, 2005, 1:29 PM
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import java.util.Map;
import javax.xml.namespace.QName;

import com.sun.xml.ws.spi.runtime.WSConnection;

/**
 *
 * @author Manisha Umbarje
 */
public class NMRTransportFactory implements com.sun.xml.ws.spi.runtime.ClientTransportFactory {

    //private QName serviceQName;
    private boolean oneWay;
    private ServiceRefPortInfo portInfo;
    
    public NMRTransportFactory(ServiceRefPortInfo portInfo, boolean oneWay) {
        //setServiceQName(portInfo.getServiceReference().getServiceName());
        setOneWay(oneWay);
        setServicePortInfo(portInfo);
    }
    public WSConnection create() {
        NMRClientConnection transport = 
                new NMRClientConnection(portInfo, oneWay);
	return transport;
    }

    public WSConnection create(Map<String, Object> context) {
        NMRClientConnection transport = 
                new NMRClientConnection(portInfo, oneWay);
	return transport;
    };
    
    /*public void setServiceQName(QName q) {
	serviceQName = q;
    }*/

     
    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }
    
    public void setServicePortInfo(ServiceRefPortInfo portInfo) {
        this.portInfo = portInfo;
    }
}
