/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

/**
 * Exception that denotes a warning or error condition in the 
 * annotation procesing tool
 *
 * @author Jerome Dochez
 */
public class AnnotationProcessorException extends Exception {
    
    final private String message;
    
    final private AnnotationInfo locator;
    
    boolean isFatal = false;
    
    /** 
     * Creats a new annotation exception
     * @param message describing the exception cause
     */
    public AnnotationProcessorException(String message) {
        this.message = message;
        this.locator = null;
    }
    
    /**
     * Creates a new annotation exception 
     * @param message describing the exception cause
     * @param locator gives information about the annotation and 
     * the annotated element which caused the exception
     */
    public AnnotationProcessorException(String message, AnnotationInfo locator) {
        this.message = message;
        this.locator = locator;
    }
    
    /**
     * Return a meaningful string explaining the exception cause
     * @return the exception reason
     */
    public String getMessage() {
        return message;
    }
    
    /**
     * Return information about the annotation and annotated element 
     * which caused the exception or null if it is not available.
     * @return the annotation info instance 
     */
    public AnnotationInfo getLocator() {
        return locator;
    }
    
    /**
     * @return a meaningful description
     */
    public String toString() {
        return (locator==null?message:message + "at " + locator);
    }
    
    /**
     *
     * @return true if this exception was considered by the sender as being
     * fatal to the annotations processing(i.e. it should stop).
     */
    public boolean isFatal(){
        return isFatal;
    }
   
    /**
     * Sets wether is exception is considered as fatal to the annotation 
     * processing.
     * @param true if the annotation processing should stop
     */
     public void setFatal(boolean fatal){
         this.isFatal = fatal;
     }      
}
