/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.stats.impl;

import javax.management.j2ee.statistics.CountStatistic;
import com.sun.appserv.management.j2ee.statistics.StringStatistic;
import com.sun.appserv.management.j2ee.statistics.NumberStatistic;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
//import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.StringStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.NumberStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.enterprise.admin.wsmgmt.stats.spi.WebServiceEndpointStatsProvider;
import com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats;

import java.util.logging.Logger;
import com.sun.enterprise.log.Log;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * A Class for providing stats for Web Service Endpoint.
 *
 * @author Satish Viswanatham
 */
public class WebServiceEndpointStatsImpl
    extends StatsImpl
    implements WebServiceEndpointAggregateStats
{
    private WebServiceEndpointStatsProvider delegate;

    private MutableCountStatisticImpl	    averageResponseTime;
    private MutableCountStatisticImpl	    responseTime;
    private MutableCountStatisticImpl	    minResponseTime;
    private MutableCountStatisticImpl	    maxResponseTime;
    private MutableCountStatisticImpl		totalFaults;
    private MutableCountStatisticImpl		totalSuccesses;
    private NumberStatisticImpl		throughput;
    private MutableCountStatisticImpl		totalAuthFailures;
    private MutableCountStatisticImpl		totalAuthSuccesses;
    private MutableCountStatisticImpl		requestSize;
    private MutableCountStatisticImpl		responseSize;
    private StringStatisticImpl		faultCode;
    private StringStatisticImpl		faultString;
    private StringStatisticImpl		faultActor;
    private StringStatisticImpl		clientHost;
    private StringStatisticImpl		clientUser;
    private static final StringManager _stringMgr =
            StringManager.getManager(WebServiceEndpointStatsProvider.class);
    

    public WebServiceEndpointStatsImpl(
        WebServiceEndpointStatsProvider delegate){
        this.delegate = delegate;

        initialize();
    }

    protected void initialize() {
       super.initialize(
       "com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats");

        averageResponseTime = new MutableCountStatisticImpl(
            new CountStatisticImpl("AverageResponseTime"));
        minResponseTime = new MutableCountStatisticImpl(
            new CountStatisticImpl("MinResponseTime"));
        maxResponseTime = new MutableCountStatisticImpl(
            new CountStatisticImpl("MaxResponseTime"));
        responseTime = new MutableCountStatisticImpl(
            new CountStatisticImpl("ResponseTime"));
        totalFaults = new MutableCountStatisticImpl(
            new CountStatisticImpl("TotalFaults"));
        totalSuccesses = new MutableCountStatisticImpl(
            new CountStatisticImpl("TotalNumSuccess"));
        totalAuthFailures = new MutableCountStatisticImpl(
            new CountStatisticImpl("TotalAuthFailures"));
        totalAuthSuccesses = new MutableCountStatisticImpl(
            new CountStatisticImpl("TotalAuthSuccesses"));
        long t = System.currentTimeMillis();
        String description = _stringMgr.getString("throughput.description");
        throughput = new NumberStatisticImpl(
            "Throughput", description, "Requests Per Second", t, t,
            new Double(0.0));
        requestSize = new MutableCountStatisticImpl(
            new CountStatisticImpl("RequestSize"));
        responseSize = new MutableCountStatisticImpl(
            new CountStatisticImpl("ResponseSize"));

    }

    public CountStatistic getAverageResponseTime(){
        averageResponseTime.setCount(delegate.getAverageResponseTime());
        return (CountStatistic) averageResponseTime.modifiableView();
    }

    public CountStatistic getResponseTime(){
        responseTime.setCount(delegate.getResponseTime());
        return (CountStatistic) responseTime.modifiableView();
    }

    public CountStatistic getMinResponseTime(){
        minResponseTime.setCount(delegate.getMinResponseTime());
        return (CountStatistic) minResponseTime.modifiableView();
    }

    public CountStatistic getMaxResponseTime(){
        maxResponseTime.setCount(delegate.getMaxResponseTime());
        return (CountStatistic) maxResponseTime.modifiableView();
    }

    public CountStatistic getTotalFaults(){
	    totalFaults.setCount(delegate.getTotalFailures());
        return (CountStatistic) totalFaults.modifiableView();
    }

    public CountStatistic getTotalNumSuccess(){
        totalSuccesses.setCount(delegate.getTotalSuccesses());
        return (CountStatistic) totalSuccesses.modifiableView();
    }

    public CountStatistic getTotalAuthFailures(){
        totalAuthFailures.setCount(delegate.getTotalAuthFailures());
        return (CountStatistic) totalAuthFailures.modifiableView();
    }

    public CountStatistic getTotalAuthSuccesses() {
        totalAuthSuccesses.setCount(delegate.getTotalAuthSuccesses());
        return (CountStatistic) totalAuthSuccesses.modifiableView();
    }

    public NumberStatistic getThroughput(){
        throughput.setNumber(new Double(delegate.getThroughput()));
        return (NumberStatistic) throughput;
    }

}
