/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * StaticTestTest.java
 *
 * Created on October 7, 2003, 5:26 PM
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import junit.framework.*;
import junit.textui.TestRunner;

/**
 *
 * @author  Rob
 */
public class StaticTestTest extends TestCase {
    
    public StaticTestTest(String name) throws Exception {
        super(name);
    }
    
    /**
     * JUnit test for method isClassPathValid in StaticTest.java. In order to
     * successfully test this method you must set the validPath variables to valid
     * paths on your filesystem.
     *
     * @author Rob Ruyak
     */
    public void testIsClassPathValid() {
        String validPath = null;
        String invalidPath = "badPath";
        String OS = System.getProperty("os.name");
        if(OS.startsWith("Win")) {  
            validPath = "C:/Sun/appserver8/jdk";
        } else {
            validPath = "/export/appserver8/jdk";
        }
        Assert.assertTrue(StaticTest.classPathCheck);
        Assert.assertTrue(StaticTest.isClassPathValid(validPath));
        Assert.assertFalse(StaticTest.isClassPathValid(invalidPath));
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite(StaticTestTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(StaticTestTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
    
}
