#!/usr/bin/perl

    if ($#ARGV != 2) {
      printUsage();
      exit;
    }
    $rng_file = shift(@ARGV);
    $names_file = shift(@ARGV);
    $out_file = shift(@ARGV);
    print "rng file: ", $rng_file , "\n";
    print "names description file: ", $names_file, "\n";
    print "output file: ", $out_file, "\n";
    open(RNG, $rng_file) || warn "Can't open file $rng_file: $!\n";
    open(NAMES, $names_file) || warn "Can't open file $names_file: $!\n";
    open(OUTP, ">".$out_file) || warn "Can't open file $out_file: $!\n";
    while (<RNG>) {
        if(/<rng:grammar/) {
            print OUTP "<foo>  \n";
        }
        print OUTP $_ ;
    }
    while (<NAMES>) {
        print OUTP $_ ;
    }
    print OUTP "</foo>  \n" ;
    exit;
   
    $user = /%REPLACE_BY_DB_USER%/;
    $pass = /%REPLACE_BY_DB_PASS%/;
    $sid  = /%REPLACE_BY_DB_SID%/;
#    $user = 'alexkrav';
#    $pass = 'alexkrav';
#    $sid  = 'bell';
    $db_prefix  = 'BX40_';


    # arguments
    $rule_name = "";
    $inher_crs = "";
    $dup_crs   = "";
    $dag_crs   = "";

    if(!($rule_name = shift(@ARGV)))
      {
         printUsage();
         exit;
      }
    if(!($inher_crs = shift(@ARGV)))
      {
         printUsage();
         exit;
      }
    if(($dup_crs = shift(@ARGV)))
      {
         $dag_crs = shift(@ARGV)
      }

    print ("Change rules CRSs\n");
    print ("Rule name: $rule_name\n");
    print ("New inheritance CRS: $inher_crs\n");
    if($dup_crs)
       {
          print ("New DUP CRS: $dup_crs\n");
       }
    if($dag_crs)
       {
          print ("New DAG CRS: $dag_crs\n");
       }
    print ("\n");

    open(TEMPFILE, ">tempsql.sql")||die "Can't open output file 'tempsql.sql': $!\n";


    print TEMPFILE ("set linesize 999\n");
    print TEMPFILE ("set pagesize 999\n");
    $stmt = "UPDATE  $db_prefix"."assignment set inher_crs=$inher_crs WHERE attr_id=(SELECT attr_id FROM  $db_prefix"."attrs WHERE ATTR_NAME= '$rule_name');";
    print TEMPFILE ("$stmt\n");
    if($dup_crs)
       {
         if($dag_crs)
            {
               $stmt = "UPDATE  $db_prefix"."attrs set dup_crs=$dup_crs,dag_crs=$dag_crs WHERE ATTR_NAME= '$rule_name';";
            }
         else
            {
               $stmt = "UPDATE  $db_prefix"."attrs set dup_crs=$dup_crs WHERE ATTR_NAME= '$rule_name';";
            }
         print TEMPFILE ("$stmt\n");
       }
    print TEMPFILE ("exit;\n");
    close(TEMPFILE);

    $logon = $user.'/'.$pass.'@'.$sid;
    $lines = `sqlplus -S $logon  \@tempsql.sql`;
print ("lines=$lines\n");

exit;

sub printUsage
{
      print "usage perl mergeRngWithNAmeDomains domain.rng names.xml out.xml";
   print ("Merges domain rng file with name-domains descriptions.\n");
   print ("Usage: \n");
   print ("       generateNameDomains.pl <domain rng file> <names domains descriptions> <output file>");
}