/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.Locale;
import java.util.logging.Level;
import java.io.File;
import java.util.Vector;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.validation.AttrClassName;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;

/**
    Custom Test for Profiler Test which calls the Generic Validation before performing custom tests

    @author Srinivas Krishnan
    @version 2.0
*/

public class ProfilerTest extends GenericValidator {
    
    public ProfilerTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce); // Before doing custom validation do basic validation
        
        if(cce.getChoice().equals(StaticTest.VALIDATE)) {
            Profiler profiler = (Profiler) cce.getObject();
            validateAttribute(ServerTags.CLASSPATH, profiler.getClasspath(), result);
            JvmOptionsTest.validateJvmOptions(profiler.getJvmOptions(), result);
        }
        
        if(cce.getChoice().equals(StaticTest.UPDATE))  {
            validateAttribute(cce.getName(), (String) cce.getObject(), result);
        }
        else if(cce.getChoice().equals(StaticTest.SET))  {
           final String name = cce.getName();
           /*
            * JvmOptions is an element in domain xml. Hence for JvmOptions we
            * need to use camelized name even thouth it is treated as an 
            * attribute.
            */
            if (name.equals("JvmOptions")) {
                JvmOptionsTest.validateJvmOptions((String[])cce.getObject(), result);
            }
        }
        return result;
    }
    
    public void validateAttribute(String name, String value, Result result) {
        
        if(value == null || value.equals(""))
            return;
        if(name.equals(ServerTags.CLASSPATH)) {
            if(!StaticTest.isClassPathValid(value)) {
                result.failed(smh.getLocalString(getClass().getName() + ".invalidProfilerClasspath",
                   "Attribute:(classpath={0}), Invalid path in classpath", new Object[]{value}));
            }
        }
    }
}
