/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.Vector;

/**
 *  Class which contains all the descriptor information for a particular element in a object used
 *  used by GenericValidator

    @author Srinivas Krishnan
    @version 2.0
*/

public class ValidationDescriptor {
  
    String elementName;
    String xPath;
    String customValidatorClass;
    String key;
    Vector attrType;
    DomainMgr domainMgr;
    String[] requiredChildren;
    String[] exclusiveChildren;
    
    public ValidationDescriptor(DomainMgr domainMgr, String elementName, 
            String xPath, String customValidatorClass, 
            String key, Vector attrType, 
            String[] required_children, String[] exclusive_children) {
        this.domainMgr = domainMgr;
        this.elementName = elementName;
        this.xPath = xPath;
        this.customValidatorClass = customValidatorClass;
        this.key = key;
        this.attrType = attrType;
        this.requiredChildren  = required_children;
        this.exclusiveChildren = exclusive_children;
    }
    
    public String getElementName() {
        return elementName;
    }
    
    public String getXPath() {
        return xPath;
    }
    
    public String getCustomValidatorClass() {
        return customValidatorClass;
    }
    
    public String getKey() {
        return key;
    }
    public Vector getAttributes() {
        return attrType;
    }

    public String[] getRequiredChildren() {
        return requiredChildren;
    }

    public String[] getExclusiveChildren() {
        return exclusiveChildren;
    }
    
    public DomainMgr getDomainMgr() {
        return domainMgr;
    }
}
