/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import java.util.*;
import javax.management.*;
//import com.sun.management.j2se.MOAgents.MOAgentFactory;
import com.sun.enterprise.management.util.J2EEModuleCallBack;


public abstract class J2EEModuleMdl extends J2EEDeployedObjectMdl {
    HashSet externalVMs = new HashSet();

    J2EEModuleMdl(J2EEModuleCallBack module) {
        super(module);
    }

    public String [] getjavaVMs() {
        //get the internal VM name
        //App Clients never run on the internal VM
        Set res = new HashSet();
        if (!(this instanceof AppClientModuleMdl)) {
            //res.addAll(findNames("j2eeType=JVM,name=" + MOAgentFactory.getAgent().getJVMId()));
        }
        //get the external VM names
        Iterator vmNames = externalVMs.iterator();
        while(vmNames.hasNext()) {
              String vmName = (String)vmNames.next();
              Set x = findNames("j2eeType=JVM,name=" + vmName);
              if(x.size() > 0) {
        		res.addAll(x);
              } else {
                //no longer an active VM
                externalVMs.remove(vmName);
                vmNames = externalVMs.iterator();
              }
        }
        Iterator it = res.iterator();
        String [] vms = new String [res.size()];
        int i =0;
        while(it.hasNext()) {
            vms[i++] = ((ObjectName)it.next()).toString();
        }
        return vms;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+this.getModuleName()+",J2EEApplication="+this.getJ2EEApplication()+",J2EEServer="+this.getJ2EEServer());
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }

    public void addVm(String name) {
        externalVMs.add(name);
    }
    /**
     * Overriding method of ManagedObject 
     */
    public boolean isstateManageable() {
	/*
        if(this.getJ2EEApplication().equals("null"))
            return true;
	*/
        return false;
    }
    /**
     * Overriding method of ManagedObject 
     */
    public boolean iseventProvider() {
        if(this.getJ2EEApplication().equals("null"))
            return true;
        return false;
    }

    public abstract String getModuleName();
    public abstract String getJ2EEApplication();

    public static boolean isStandAloneModule(String applicationName){
	if ( applicationName == null 
	     || applicationName.equals("") 
	     || applicationName.equals("null") ) {
	    return true;
	}
        return false;
    } 
}
